class Smartphone {
    // 필드
    private String manufacturer;   // 제조사
    private String model;          // 모델
    private int battery;           // 배터리 잔량 (0~100%)

    // 생성자
    public Smartphone(String manufacturer, String model) {
        this.manufacturer = manufacturer;
        this.model = model;
        this.battery = 100;  // 새 스마트폰은 배터리 100%로 시작
    }

    // Getter와 Setter
    public String getManufacturer() {
        return manufacturer;
    }

    public String getModel() {
        return model;
    }

    public int getBattery() {
        return battery;
    }

    public void setBattery(int battery) {
        if (battery < 0) {
            this.battery = 0;
        } else if (battery > 100) {
            this.battery = 100;
        } else {
            this.battery = battery;
        }
    }

    // 메서드: 충전
    public void charge(int amount) {
        setBattery(this.battery + amount);
        System.out.println("충전 완료! 현재 배터리: " + this.battery + "%");
    }

    // 메서드: 사용
    public void use(int amount) {
        if (this.battery - amount < 0) {
            System.out.println("배터리가 부족합니다. 충전이 필요합니다!");
            this.battery = 0;
        } else {
            this.battery -= amount;
            System.out.println("스마트폰을 사용했습니다. 현재 배터리: " + this.battery + "%");
        }
    }

    // toString() 오버라이딩
    @Override
    public String toString() {
        return manufacturer + " " + model + " (배터리: " + battery + "%)";
    }
}

public class SmartphoneTest {
    public static void main(String[] args) {
        Smartphone phone = new Smartphone("Samsung", "Galaxy S25");

        System.out.println(phone); // toString() 호출

        phone.use(30);    // 30% 배터리 사용
        phone.use(80);    // 배터리 부족 상황
        phone.charge(50); // 50% 충전
        phone.setBattery(120); // 범위를 벗어난 값 → 100으로 조정

        System.out.println("최종 상태: " + phone);
    }
}