public class BitwiseAndShiftExample {
    public static void main(String[] args) {
        int a = 5;   // (2진수: 00000000 00000000 00000000 00000101)
        int b = 3;   // (2진수: 00000000 00000000 00000000 00000011)

        System.out.println("a: " + a + " (" + Integer.toBinaryString(a) + ")");
        System.out.println("b: " + b + " (" + Integer.toBinaryString(b) + ")");

        int r1 = a & b; // a와 b의 비트 AND 연산
        System.out.println("a & b: " + r1 + " (" + Integer.toBinaryString(r1) + ")");

        int r2 = a | b; // a와 b의 비트 OR 연산
        System.out.println("a | b: " + r2 + " (" + Integer.toBinaryString(r2) + ")");

        int r3 = a ^ b; // a와 b의 비트 XOR 연산
        System.out.println("a ^ b: " + r3 + " (" + Integer.toBinaryString(r3) + ")");

        int r4 = ~a; // a의 비트 NOT 연산
        System.out.println("~a: " + r4 + " (" + Integer.toBinaryString(r4) + ")");

        int r5 = a << 1; // a의 비트를 1칸 왼쪽으로 이동
        System.out.println("a << 1: " + r5 + " (" + Integer.toBinaryString(r5) + ")");

        int r6 = a >> 1; // a의 비트를 1칸 오른쪽으로 이동(부호 유지)
        System.out.println("a >> 1: " + r6 + " (" + Integer.toBinaryString(r6) + ")");

        int r7 = a >>> 1; // a의 비트를 1칸 오른쪽으로 이동(부호 무시)
        System.out.println("a >>> 1: " + r7 + " (" + Integer.toBinaryString(r7) + ")");

    }
}
